package com.aubay.formations.nr;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;

import org.h2.tools.Server;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;

import com.aubay.formations.nr.entities.Employee;
import com.aubay.formations.nr.entities.User;
import com.aubay.formations.nr.enums.LangEnum;
import com.aubay.formations.nr.repositories.CountryRepository;
import com.aubay.formations.nr.repositories.EmployeeRepository;
import com.aubay.formations.nr.repositories.UsageRepository;
import com.aubay.formations.nr.repositories.UserRepository;
import com.aubay.formations.nr.utils.DataGenerator;

/**
 * Application Runner
 *
 * @author jbureau@aubay.com
 */
@SpringBootApplication
public class ApplicationFormateur {

	@Autowired
	private EmployeeRepository employeeRepository;

	@Autowired
	private CountryRepository countryRepository;

	@Autowired
	private UserRepository userRepository;

	@Autowired
	private UsageRepository usageRepository;

	@Value("${spring.jpa.properties.hibernate.hbm2ddl.auto}")
	private String mode;

	/**
	 * WebApplication Runner (Main method)
	 */
	public static void main(final String[] args) {
		SpringApplication.run(ApplicationFormateur.class, args);
	}

	@Bean(initMethod = "start", destroyMethod = "stop")
	public Server inMemoryH2DatabaseaServer() throws SQLException {
		return Server.createTcpServer("-tcp", "-tcpAllowOthers", "-tcpPort", "9090");
	}

	/**
	 * Initialize Database
	 * @formatter:off
	 */
	@EventListener(ApplicationReadyEvent.class)
	public void dbinit() {
		if(mode.equals("validate")) {
			return;
		}
		final var firstname = "Roger";
		final var lastname = "GERMAIN";
		final var username = "formation";
		final var password = "aubay";
		final var countryCode = "Fr";
		final var role = "USER";
		final var entryDate = new Date();
		final var salary = 25678;
		countryRepository.saveAll(DataGenerator.generateCountries());
		employeeRepository.saveAll(DataGenerator.generateEmployees(15, 4));
		employeeRepository.saveAll(DataGenerator.generateEmployees(10, 6));
		employeeRepository.saveAll(DataGenerator.generateEmployees(15, 5));
		employeeRepository.saveAll(DataGenerator.generateEmployees(25, 3));
		employeeRepository.saveAll(DataGenerator.generateEmployees(15, 3));
		final var country = countryRepository.getReferenceById(countryCode);
		final var employee = Employee.builder()
				.id(1)
				.firstname(firstname)
				.lastname(lastname)
				.country(country)
				.entryDate(entryDate)
				.salary(salary)
				.build();
		final var user = User.builder()
				.username(username)
				.password(PasswordEncoderFactories.createDelegatingPasswordEncoder().encode(password))
				.authorities(Arrays.asList(new SimpleGrantedAuthority(role)))
				.enabled(true)
				.preferredLang(LangEnum.FR)
				.employee(employee)
				.build();
		employeeRepository.save(employee);
		userRepository.save(user);
		usageRepository.saveAll(DataGenerator.generateUsages(10000));
	}
}
