package com.aubay.formations.nr.config;

import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * Web security configuration
 *
 * @formatter:off
 * @author jbureau@aubay.com
 */
@EnableWebSecurity
public class WebSecurityConfig {

	@Bean
	public SecurityFilterChain filterChain(final HttpSecurity http) throws Exception {
		// API Security
		http.authorizeRequests(authorize -> authorize.requestMatchers("/**").permitAll());
		// Enable CORS
		http.cors();
		// Disable CSRF
		http.csrf().disable();
		// Conf for h2-console
		http.headers().frameOptions().disable();
		return http.build();
	}

}