package com.aubay.formations.nr.controllers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import com.aubay.formations.nr.repositories.EmployeeRepository;
import com.aubay.formations.nr.repositories.UsageRepository;
import com.aubay.formations.nr.utils.DataGenerator;

/**
 * Application controller 
 *
 * @author jbureau@aubay.com
 */
@RestController
public class ApplicationController {

	@Autowired
	private EmployeeRepository employeeRepository;
	
	@Autowired
	private UsageRepository usageRepository;


	/**
	 * Initialize database (Mocked data)
	 */
	@GetMapping("/generateEmployees")
	public void generateEmployees() {
		employeeRepository.saveAll(DataGenerator.generateEmployees(15, 6));
	}
	
	@GetMapping("/generateStats")
	public void generateStats() {
		usageRepository.saveAll(DataGenerator.generateUsages(10000));
	}
}
