package com.aubay.formations.nr.config;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

import lombok.extern.log4j.Log4j2;

/**
 * Error Handler Catch every exceptions and send message error to client
 *
 * @author jbureau@aubay.com
 */
@Log4j2
@ControllerAdvice
public class ErrorHandler extends ResponseEntityExceptionHandler {

	public ResponseEntity<Object> error(final Exception ex, final HttpStatus status, final WebRequest request) {
		log.error("Exception occured in application", ex);
		return super.handleExceptionInternal(ex, ex.getMessage(), new HttpHeaders(), status, request);
	}

	@ExceptionHandler
	protected ResponseEntity<Object> handleConflict(final RuntimeException ex, final WebRequest request) {
		return error(ex, HttpStatus.INTERNAL_SERVER_ERROR, request);
	}

}
